RORXU008 ;HCIOFO/SG - REPORT PARAMETERS (CONT.) ; 6/21/06 2:08pm
 ;;1.5;CLINICAL CASE REGISTRIES;**1**;Feb 17, 2006;Build 24
 ;
 Q
 ;
 ;***** PROCESSES THE LIST OF ICD-9 CODES
 ;
 ; .RORTSK       Task number and task parameters
 ;
 ; PARTAG        Reference (IEN) to the parent tag
 ;
 ; .ROR8LST      Reference to a local variable, which contains a
 ;               closed root of an array. IEN's of ICD-9 codes
 ;               will be returned into this array.
 ;
 ;                 @ROR8LST@(IEN,Group#) = ""
 ;
 ;               If this parameter is undefined or empty, then a
 ;               temporary buffer is allocated by the $$ALLOC^RORTMP
 ;               function and its root is returned via this parameter.
 ;
 ;               If all ICD-9 codes are requested (the "ALL" attribute
 ;               of the "ICD9LST" tag), then "*" is returned.
 ;
 ; [.GRPLST]     Reference to a local variable that will contain
 ;               the list of ICD-9 groups.
 ;
 ;                 GRPLST(
 ;                   "C",Group#)    = GroupName
 ;                   "N",GroupName) = Group#
 ;
 ; Return Values:
 ;       <0  Error code
 ;       >0  IEN of the ICD9LST element
 ;
ICD9LST(RORTSK,PARTAG,ROR8LST,GRPLST) ;
 N ATTR,ICD9,ICD9ALL,ICD9OPTS,IEN,LTAG,RC,TMP
 S ICD9ALL=+$$PARAM^RORTSK01("ICD9LST","ALL")
 S (LTAG,RC)=0
 ;
 ;=== Validate parameters
 I 'ICD9ALL  D  K @ROR8LST
 . S:$G(ROR8LST)="" ROR8LST=$$ALLOC^RORTMP()
 E  S ROR8LST="*"
 ;
 ;=== Process the drug options (if present)
 M ICD9OPTS=RORTSK("PARAMS","ICD9LST","A")
 I $D(ICD9OPTS)>1  D  Q:LTAG'>0 LTAG
 . S ATTR=$S(ICD9ALL:"ALL",1:"")
 . S LTAG=$$ADDVAL^RORTSK11(RORTSK,"ICD9LST",ATTR,PARTAG)
 . Q:LTAG'>0
 . ;--- Output option attributes
 . S ATTR="",RC=0
 . F  S ATTR=$O(ICD9OPTS(ATTR))  Q:ATTR=""  D  Q:RC<0
 . . S RC=$$ADDATTR^RORTSK11(RORTSK,LTAG,ATTR,"1")
 . I RC<0  S LTAG=RC  Q
 . S ATTR=$$OPTXT^RORXU002(.ICD9OPTS)
 . D:ATTR'="" ADDATTR^RORTSK11(RORTSK,LTAG,"DESCR",ATTR)
 ;
 ;=== Process the list of ICD-9 codes (if present)
 I 'ICD9ALL  D:$D(RORTSK("PARAMS","ICD9LST","G"))>1
 . N GRPNAME,GRPTAG,IG,NODE
 . I LTAG'>0  D  Q:LTAG'>0
 . . S LTAG=$$ADDVAL^RORTSK11(RORTSK,"ICD9LST",,PARTAG)
 . ;---
 . S NODE=$NA(RORTSK("PARAMS","ICD9LST","G"))
 . S GRPNAME="",RC=0
 . F  S GRPNAME=$O(@NODE@(GRPNAME))  Q:GRPNAME=""  D  Q:RC<0
 . . S IG=$O(GRPLST("C",""),-1)+1
 . . S GRPLST("C",IG)=GRPNAME,GRPLST("N",GRPNAME)=IG
 . . S GRPTAG=$$ADDVAL^RORTSK11(RORTSK,"GROUP",,LTAG)
 . . I GRPTAG'>0  S RC=GRPTAG  Q
 . . D ADDATTR^RORTSK11(RORTSK,GRPTAG,"NAME",GRPNAME)
 . . S IEN=0
 . . F  S IEN=$O(@NODE@(GRPNAME,"C",IEN))  Q:IEN'>0  D
 . . . S ICD9=$P(@NODE@(GRPNAME,"C",IEN),U)  Q:ICD9=""
 . . . D ADDVAL^RORTSK11(RORTSK,"ICD9",ICD9,GRPTAG,,IEN)
 . . . S @ROR8LST@(IEN,IG)=""
 ;
 ;===
 Q $S(RC<0:RC,1:LTAG)
 ;
 ;***** FUNCTION FOR THE PHARMACY SEARCH API
 ;
 ; .GRPLST       Reference to a local variable that contains a list
 ;               of group codes. It is used to determine if codes
 ;               from all groups were found.
 ;
 ; ICD9IEN       IEN of the ICD-9 code
 ;
 ; ROR8LST       Closed root of the ICD-9 list generated by the
 ;               $$ICD9LST^RORXU008 function or "*" for all drugs.
 ;
 ; Return Values:
 ;        0  Ok
 ;        1  Skip the record
 ;
ICDGRCHK(GRPLST,ICD9IEN,ROR8LST) ;
 Q:ROR8LST="*" 0
 Q:$D(@ROR8LST@(ICD9IEN))<10 1
 N GRP  S GRP=""
 F  S GRP=$O(@ROR8LST@(ICD9IEN,GRP))  Q:GRP=""  K GRPLST(GRP)
 Q 0
